Attribute VB_Name = "CtrlCard"
'****************************Motion control module *************************

    ' For developing an application system of great generality, extensibility and
    'convenient maintenance easily and swiftly, we envelop all the library functions
    'by category basing on the card function library

'*******************************************************************
Public Result As Integer     'retun value

Public g_nom  As Integer      '


Const MULTIPLE = 5           'ratio

Const MAXAXIS = 6           'max axis number

'******************************initial motion-card***************************

    'this function is boot of using motion-card
    'Return<=0 fail to initial motion-card
    'Return>0  Succeed in initial motion-card
    
'*******************************************************************
Public Function Init_Card() As Integer
       
    Result = adt856_initial
    
    If Result <= 0 Then
     
       Init_Card = Result
       
       Exit Function
       
    End If
       
    For i = 1 To MAXAXIS
             
       set_range 0, i, CLng(8000000 / 5)     'set range,set ratio as 5
       
       set_command_pos 0, i, 0               'set logic pos as 0
       
       set_actual_pos 0, i, 0                'set real pos as 0
       
       set_startv 0, i, 1000                 'set start-speed
         
       set_speed 0, i, 1000                  'set motion-speed
       
       set_acc 0, i, 625                     'set acceleration
     
    Next i
    
    Init_Card = Result
       
End Function



'************************* release of ADT8948 source occupied***********************
Public Function End_Board() As Integer

     Result = adt856_end
     
     End_Board = Result
    
End Function
'
'***********************set stop0 mode**********************
'
'Set mode of stop0 input signal
'
'para    axisaxis number
'          value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'Defaule:     ineffective
'
'Return   0Correct                  1 Wrong
'  *****************************************************************
Public Function Setup_Stop0Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop0Mode = set_stop0_mode(0, axis, value, logic)
    
End Function

'************************set stop1 mode*********************
'**
'   Set mode of stop1 input signal
'
'   para axisaxis number
'          value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'Defaule:     ineffective
'
'   Return   0Correct                  1 Wrong

'  *****************************************************************
Public Function Setup_Stop1Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop1Mode = set_stop1_mode(0, axis, value, logic)
    
End Function
'************************set stop2 mode*********************
'
'   Set mode of stop2 input signal
'
'   para axisaxis number
'          value   0ineffective  1effective
'          logic   0low level effective  1high level effective
'Defaule:     ineffective
'
'   Return   0Correct                  1 Wrong
'  *****************************************************************
Public Function Setup_Stop2Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop2Mode = set_stop2_mode(0, axis, value, logic)
    
End Function

'**********************set real position counter**********************

'cardno     Card number
'axis       Axis number1-4
'value      Input of pulse pattern
'0        A/B pulse input  1up/downPPIN/PMINpulse input
'dir        Counter direction
'0       A is over B or PPIN impulse input is up counted.
'          B is over A or PMIN impulse is down counted
'1       B is over A or PPIN impulse input is up counted
'          A is over B or PMIN impulse is down counted.
'freq      During double frequency of A/B input up/down impulse input is non-effective
'04-time frequency     12-time frequency        2No-time frequency
'Returning value: 0: Correct    1: False
'Initialized status: During A/B phase impulse input direction is of 0 and 4-time frequency.
'
'*******************************************************************
Public Function Actualcount_Mode(ByVal axis As Integer, ByVal value As Integer, ByVal dir As Integer, ByVal freq As Integer) As Integer
    
    Result = set_actualcount_mode(0, axis, value, dir, freq)
    
    Actualcount_Mode = Result

End Function

'**************************set pulse output mode*************************
'
'    set the mode of pulse output
'    paraaxis-axis number value-pulse mode 0pulse+pulse 1pulse + direction
'    Return=0 correctReturn=1 wrong
'    Default mode: Pulse + direction, with positive logic pulse
'    and positive logic direction input signal
'
'*******************************************************************
Public Function Setup_PulseMode(ByVal axis As Integer, ByVal value As Integer) As Integer

    Setup_PulseMode = set_pulse_mode(0, axis, value, 0, 0)
    
End Function
'****************************set limit signal mode***********************
''
'   set the mode of nLMT signal input along positive/ negative direction
'
'   para axisaxis number
'          value   0: sudden stop effective      1: decelerate stop effective
'         logic    0: low level effective           1: high level ineffective
'   Default mode: Apply positive and negative limits with low level
'
'   Return   0Correct                  1 Wrong
'  *****************************************************************
Public Function Setup_LimitMode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_LimitMode = set_limit_mode(0, axis, value, logic)
    
End Function

'*********************set COMP+counter as soft limit****************
'
'cardno      card number
'
'axis        axis number1-4
'
'Value       0: ineffective 1: effective
'
'Return      0Correct              1Wrong
'
'Default mode: ineffective
'NoticeSoftware position limiting always adopts acceleration to stop.
'Calculating value may be over set up value. Within setup sphere it must be considered.
'*******************************************************************
'*******************************************************************
Public Function Setsoft_LimitMode1(ByVal axis As Integer, ByVal value As Integer) As Integer

    Result = set_softlimit_mode1(0, axis, value)

    Setsoft_LimitMode1 = Result
    
End Function

'*******************set COMP-counter as soft limit******************
'
'cardno      card number
'axis        axis number1-4
'Value       0: ineffective          1: effective
'Return      0Correct              1Wrong
'Default mode: ineffective
'NoticeSoftware position limiting always adopts acceleration to stop.
'Calculating value may be over set up value. Within setup sphere it must be considered.
'  *****************************************************************
'  *****************************************************************
Public Function Setsoft_LimitMode2(ByVal axis As Integer, ByVal value As Integer) As Integer

    Result = set_softlimit_mode2(0, axis, value)

    Setsoft_LimitMode2 = Result
    
End Function

'******************set COMP+/-counter*****************
'
'cardno      card number
'axis        axis number1-4
'Value       0: ineffective          1: effective
'Return      0Correct              1Wrong
'Default mode: ineffective
'NoticeSoftware position limiting always adopts acceleration to stop.
'Calculating value may be over set up value. Within setup sphere it must be considered.
'
'  *****************************************************************

Public Function Setsoft_LimitMode3(ByVal axis As Integer, ByVal value As Integer) As Integer

    Result = set_softlimit_mode3(0, axis, value)

    Setsoft_LimitMode3 = Result
    
End Function

'********************set nINPOS(in-position input sigal)******************
'
'cardno      card number
'axis        axis number1-4
'Value       0: ineffective       1: effective
'logic       0Effective when low electric level        1Effective when low electric level
'Return      0Correct              1Wrong
'Default mode :  noneffective, low electric level is effective

'*******************************************************************
Public Function Inpos_Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Result = set_inpos_mode(0, axis, value, logic)

    Inpos_Mode = Result
    
End Function

'********************set nALARM(alarm input sigal)******************

'cardno      card number
'axis        axis number1-4
'Value       0: ineffective       1: effective
'logic       0Effective when low electric level        1Effective when low electric level
'Return      0Correct              1Wrong
'Default mode :  noneffective, low electric level is effective

'*******************************************************************

Public Function Setup_AlarmMode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Result = set_alarm_mode(0, axis, value, logic)

    Setup_AlarmMode = Result
    
End Function

'***************************set speed***********************
'   according as para,judge whether is constant-speed
'   set range to set ratio
'   set start-speed ,motion-speed and acceleration
'para:     axis:   axis number
'startv:           start -speed
'speed:            motion -speed
'add:              acceleration
'dec:              decelerate
'ratio:            ratio
'mode:             mode
'     Return=0 correctReturn=1 wrong
'*******************************************************************
Public Function Setup_Speed(ByVal axis As Integer, ByVal startv As Long, ByVal Speed As Long, ByVal add As Long, ByVal Dec As Long, ByVal ratio As Long, ByVal Mode As Integer) As Integer

   If (startv - Speed >= 0) Then
    
        set_range 0, axis, 8000000 / ratio
    
        Result = set_startv(0, axis, startv / ratio)
    
        set_speed 0, axis, startv / ratio
        
    Else
    
        Select Case Mode
            
        Case 0
            
            set_dec1_mode 0, axis, 0
                
            set_dec2_mode 0, axis, 0
    
            Result = set_range(0, axis, 8000000 / ratio)
                
            set_startv 0, axis, startv / ratio
                
            set_speed 0, axis, Speed / ratio
                
            set_acc 0, axis, add / 125 / ratio
                
            set_ad_mode 0, axis, 0
             
       
         Case 1
            
             set_dec1_mode 0, axis, 1
                
             set_dec2_mode 0, axis, 0
                
             Result = set_range(0, axis, 8000000 / ratio)
                
             set_startv 0, axis, startv / ratio
                
             set_speed 0, axis, Speed / ratio
                
             set_acc 0, axis, add / 125 / ratio
                
             set_dec 0, axis, Dec / 125 / ratio
                
            set_ad_mode 0, axis, 0
                
          Case 2
            
              Dim time As Double
                 
              Dim addvar As Double
                 
              Dim k As Long
               
             time = (Speed - startv) / (add / 2)

             addvar = add / (time / 2)

             k = (62500000 / addvar) * ratio

             set_dec2_mode 0, axis, 0

             Result = set_range(0, axis, 8000000 / ratio)
        
             set_startv 0, axis, startv / ratio
             
             set_speed 0, axis, Speed / ratio
        
             set_acc 0, axis, add / 125 / ratio
        
             set_acac 0, axis, k
        
             set_ad_mode 0, axis, 1
                 
             Setup_Speed = Result
             
         End Select
             
     End If

End Function

'****************************single-axis motion***************************
'
'    drive one axis motion
'
'    para axis-axis numbervalue-pulse of motion
'
'    Return=0 correctReturn=1 wrong

'*******************************************************************
Public Function Axis_Pmove(ByVal axis As Integer, ByVal value As Long) As Integer
    
    Result = pmove(0, axis, value)
    
    Axis_Pmove = Result
    
End Function

'****************************single-axis continuous motion***************************
'
'    drive one axis continuous motion
'
'    para axis-axis numbervalue-pulse of motion
'
'    value: 0:positive direction    1:negative direction
'
'    Return=0 correctReturn=1 wrong
'
'*******************************************************************
Public Function Axis_Cmove(ByVal axis As Integer, ByVal value As Long) As Integer

    Result = continue_move(0, axis, value)
    
    Axis_Cmove = Result

End Function

'/**********************2-axis interpolation*********************
'
'  for XY or ZW 2-axis linear interpolation
'     no ->   1: X-Y       2:Z-W
'
'       Return=0 correctReturn=1 wrong
'
'***********************************************************/
Public Function Interp_Move2(ByVal no As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer

    Result = inp_move2(0, no, pulse1, pulse2)
    
    Interp_Move2 = Result
    
End Function

'/*********************3-axis interpolation**********************
'
'  for XYZ 3-axis linear interpolation
'
'    Return=0 correctReturn=1 wrong
'
'***********************************************************/

Public Function Interp_Move3(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer

    Result = inp_move3(0, pulse1, pulse2, pulse3)
    
    Interp_Move3 = Result
    
End Function


'/*********************4-axis interpolation**********************
'
'  for XYZW 4-axis linear interpolation
'
'    Return=0 correctReturn=1 wrong
'
'***********************************************************/
Public Function Interp_Move4(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long) As Integer
    
    Result = inp_move4(0, pulse1, pulse2, pulse3, pulse4)
    
    Interp_Move4 = Result
    
End Function


'/*********************6-axis interpolation**********************
'
'  for XYZWUV 6-axis linear interpolation
'
'    Return=0 correctReturn=1 wrong
'
'***********************************************************/
Public Function Interp_Move6(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long) As Integer
    
    Result = inp_move6(0, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6)
    
    Interp_Move6 = Result
    
End Function

'*********************Clockwise CW circular interpolation********************

'axis1,axis2    1X   2:Y   3Z  4:W
' x,y        Terminal position of Arc SR (corresponding to starting point)
' i,j        Central point position of SR circle arc (corresponding to starting point)
'return      0Correct     1False

'*******************************************************************

Public Function Interp_Arc(ByVal no As Integer, ByVal x As Long, ByVal y As Long, ByVal i As Long, ByVal j As Long) As Integer

     Interp_Arc = inp_cw_arc(0, no, x, y, i, j)

End Function

'**********************Clock against CCW circular interpolation**********************

'axis1,axis2     1X    2Y    3Z   4W
'x,y             Terminal position of Arc SR (corresponding to starting point)
'i,j             Central point position of SR circle arc (Corresponding to starting point)
'return      0Correct     1False

'*******************************************************************

Public Function Interp_CcwArc(ByVal no As Integer, ByVal x As Long, ByVal y As Long, ByVal i As Long, ByVal j As Long) As Integer

     Interp_CcwArc = inp_ccw_arc(0, no, x, y, i, j)

End Function

'*********************position counter variable ring****************

'axis     axis number1-4
'Value    0: ineffective       1: effective
'return   0Correct     1False
'Default mode :  noneffective

'*******************************************************************

Public Function SetCircle_Mode(ByVal axis As Integer, ByVal value As Integer) As Integer

     Result = set_circle_mode(0, axis, value)

     SetCircle_Mode = Result

End Function

'*******************Setup of signal wave filtering function**********************

'   number  input type
''1:         LMT ?LMT - ?STOP0?STOP1
'2:        STOP2
'3:         nINPOS?nALARM
'4:          nIN
 '   Set the filtering state of the four types input signals above
' '  value        0: Wave filter is ineffective           1: Wave filter is effective
'   Default mode: ineffective

'*******************************************************************

Public Function Setup_InputFilter(ByVal axis As Integer, ByVal number As Integer, ByVal value As Integer) As Integer

     Result = set_input_filter(0, axis, number, value)
     
     Setup_InputFilter = Result
     
End Function

'*********************setup of wave filter time constant of input signal********************

'axis       axis number(1-4)

'value      maximum noise scope deleted ,   delay of input signal

'*********************************************************************
Public Function Setup_FilterTime(ByVal axis As Integer, ByVal value As Integer) As Integer

     Result = set_filter_time(0, axis, value)
     
     Setup_FilterTime = Result
     
End Function

'/*****************stop motion********************************
'
'  stop motion in the way of sudden or decelerate
'
'    paraaxis-axis numbermode-stop mode(0sudden stop, 1decelerate stop)
'
'      Return=0 correctReturn=1 wrong
'
'***********************************************************/
Public Function StopRun(ByVal axis As Integer, ByVal Mode As Integer) As Integer

    If Mode = 0 Then             'sudden stop
        
        Result = sudden_stop(0, axis)
        
    Else                         'dec stop
    
        Result = dec_stop(0, axis)
    
    End If

End Function

'/*************************set position counter*******************************
'
'  set logic-pos or  real-pos
'
'    paraaxis-axis number,pos-the set value
'    mode 0set logic pos,non 0set real pos
'
'      Return=0 correctReturn=1 wrong
'**********************************************************************/
'*******************************************************************
Public Function Setup_Pos(ByVal axis As Integer, ByVal pos As Long, ByVal Mode As Integer) As Integer

    If Mode = 0 Then
    
        Result = set_command_pos(0, axis, pos)
        
    Else
    
        Result = set_actual_pos(0, axis, pos)
        
    End If
    
End Function

'/*************************set COMP+ register******************************
'cardno   card number
'axis         axis number
'value        range-2147483648~+2147483647
'retutrn 0: correct 1: wrong
'**********************************************************************/


Public Function Setup_Comp1(ByVal axis As Integer, ByVal value As Long)

    Result = set_comp1(0, axis, value)
    
    Setup_Comp1 = Result

End Function

'/**************************set COMP- register*****************************
'
'  cardno     card number
'  axis       axis number
'  value      range-2147483648~+2147483647
'  retutrn 0: correct 1: wrong
'
'**********************************************************************/

Public Function Setup_Comp2(ByVal axis As Integer, ByVal value As Long)

    Result = set_comp2(0, axis, value)
    
    Setup_Comp2 = Result

End Function

'/*****************get status of motion**************************
'
'    get status of single-axis motion or interpolation
'
'    paraaxis-axis numbervalue-Indicator of motion status(0Drive completed,Non-0: Drive in process)
'
'          mode(0-single-axis motion1interpolation)
'
'    Return=0 correctReturn=1 wrong
'
'***********************************************************/
Public Function Get_CurrentInf(ByVal axis As Integer, LogPos As Long, actpos As Long, Speed As Long) As Integer

    Result = get_command_pos(0, axis, LogPos)
    
    get_actual_pos 0, axis, actpos
    
    get_speed 0, axis, Speed
    
    Get_CurrentInf = Result
    
End Function


'/*****************get status of motion**************************
'
'  get status of single-axis motion or interpolation
'
'    paraaxis-axis numbervalue-Indicator of motion status(0Drive completed,Non-0: Drive in process)
'
'      mode(0-single-axis motion1interpolation)
'
'        Return=0 correctReturn=1 wrong
'
'***********************************************************/
Public Function Get_MoveStatus(ByVal axis As Integer, value As Integer, ByVal Mode As Integer) As Integer

    If Mode = 0 Then         'status of single-axis motion
    
        GetMove_Status = get_status(0, axis, value)
        
    Else                     'status of interpolation
    
        GetMove_Status = get_inp_status(0, axis, value)
        
    End If
    
End Function

'/****************************read input*******************************
'
'  read status of input
'
'    paranumber-input port(0 ~ 47)
'
'      Return0  low level1  high level-1  error
'*********************************************************************/
Public Function Read_Input(ByVal number As Integer) As Integer
    
    Read_Input = read_bit(0, number)
    
End Function

'/***************************output******************************
'
'  set status 0f output
'
'    para number-output port(0 ~ 31),value 0-low level1high level
'
'      Return=0 correctReturn=1 wrong
'**********************************************************************/
Public Function Write_Output(ByVal number As Integer, ByVal value As Integer) As Integer

    Write_Output = write_bit(0, number, value)
    
End Function

'/*****************************deceleration enable**************************
'
'  no        1X-Y or X-Y-Z or X-Y-Z-W interpolation    2Z-W interpolation
'
'    the function allowable deceleration during driving
'
'      retutrn 0: correct 1: wrong
'
'*******************************************************************/

Public Function AllowDec(ByVal no As Integer) As Integer
 
    Result = inp_dec_enable(0, no)

    AllowDec = Result
    
End Function

'/**************************deceleration disable******************************
'
'  no        1X-Y or X-Y-Z or X-Y-Z-W interpolation    2Z-W interpolation
'
'    the function for deceleration disable during driving
'
'      retutrn 0: correct 1: wrong
'
'********************************************************************/

Public Function ForbidDec(ByVal no As Integer) As Integer
 
    Result = inp_dec_disable(0, no)

    ForbidDec = Result
    
End Function

'/****************getting information about mistaken stop on all axes******************
'This function is  for getting information about the axis stop
'
'  value:     error message  0no error  1error
'
'    retutrn 0: correct 1: wrong
'
'*********************************************************************/
Public Function Get_ErrorInf(ByVal axis As Integer, value As Integer) As Integer
 
    Result = get_stopdata(0, axis, value)

    Get_ErrorInf = Result
    
End Function

'/*******get the status of continuous interpolation*****************
'
'  value  inter-infor  0write disable 1write able
'
'    retutrn 0: correct 1: wrong
'
'********************************************************************/

Public Function Get_AllowInpStatus(ByVal no As Integer, value As Integer) As Integer
 
    Result = get_inp_status2(0, no, value)

    Get_AllowInpStatus = Result
    
End Function

'/***********************set deceleration type**********************
'deceleration for symmetry/asymmetry/automatic/manual
'
'  retutrn 0: correct 1: wrong
'*********************************************************************/

Public Function Set_DecMode(ByVal axis As Integer, ByVal mode1 As Integer, ByVal mode2 As Integer) As Integer

    Dim Result1 As Integer
    
    Dim Result2 As Integer
     
    Result1 = set_dec1_mode(0, axis, mode1)
    
    Result2 = set_dec2_mode(0, axis, mode2)
    
    Set_DecMode = Result1 & Result2
    
End Function

'/***********************set deceleration point****************************
'set deceleration point during manual deceleration
'
'  retutrn 0: correct 1: wrong
'*********************************************************************/

Public Function Set_DecPos(ByVal axis As Integer, ByVal value As Long, ByVal startv As Long, ByVal Speed As Long, ByVal add As Long) As Integer
     
    Dim addtime As Double
    
    Dim DecPulse As Long
    
    addtime = (Speed - startv) / add

    DecPulse = ((startv + Speed) * addtime) / 2
    
    Result = set_dec_pos(0, axis, value - DecPulse)

    Set_DecPos = Result
    
End Function

